<?php
session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

// Fetch the user ID from the session
$userid = $_SESSION['userid'];

// Query to get the notifications for the logged-in user, ordered by date
$sql = "SELECT title, date, message FROM money_rate ORDER BY date DESC";
$stmt = $con->prepare($sql);
$stmt->execute();
$stmt->bind_result($title, $date, $message);

// Store notifications in an array
$notifications = [];
while ($stmt->fetch()) {
    $notifications[] = [
        'title' => $title,
        'date' => $date,
        'message' => $message,
    ];
}
$stmt->close();

?>

<?php include 'header-link.php' ?>

<main>

	<?php include 'top-bar.php' ?>
	
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
						
							<div class="text-center">
								<i class="profile-icon fa-solid fa-money-bill-trend-up"></i>
							</div>
							
                            <h6 class="card-title text-center my-3"> আজকের টাকার রেট </h6>

                            <div class="offer-list" id="offerList">
                                <?php foreach ($notifications as $notification): ?>
                                    <div class="offer-card mb-5 p-4">
                                        <div class="row">
                                            <div class="col-md-12 text-left">
                                                <small >
                                                <u class="fw-bold">    <?php echo htmlspecialchars($notification['title']); ?> - 
                                                    <?php echo date('d-m-Y', strtotime($notification['date'])); ?></u>
                                                </small><br>
                                                <small><?php echo htmlspecialchars($notification['message']); ?></small><br>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>


</body>
</html>
 